#ifndef PERF_QUEUE_H
#define PERF_QUEUE_H

// A queue of performance values. What is intended by "performance" queue is
// that it has the function "Performance" which counts up the number
// of "Correct" values in the queue.
// 		This is a fixed length, circular queue. The queue writes over oldest value
// if you Enqueue more than the full queue. In this way, you can keep track of the
// last N performance values, where N is the size of the queue.

// Changed, CGP, 12/20/00
// 		

class PerfQueue {
public:
  PerfQueue(int size); // max number of queue elements
  ~PerfQueue();
  void Enqueue(int item); // item is the number "correct" for a "trial"
  int Performance(); // return the number of "Correct" values for all "trials" in queue
  int CurrLength(); // number of items in queue
  void Reset(); // reset queue to empty
  
private: // members available to derived classes
  const int maxLength;
  int *queue;
  int numberItems; // number items currently in queue
  int itemIndex;
};

#endif PERF_QUEUE_H